<?php
// Include database connection
include('db.php');

// Fetch the latest order_id from the orders table
$query = "SELECT MAX(Order_id) AS latest_order_id FROM orders";
$result = mysqli_query($conn, $query);

if ($result) {
    $row = mysqli_fetch_assoc($result);
    $latest_order_id = $row['latest_order_id'];

    // Increment the latest order_id by 1
    $new_order_id = $latest_order_id + 1;

    // Return the new order_id in JSON format
    echo json_encode([
        "status" => "success",
        "new_order_id" => $new_order_id
    ]);
} else {
    // Handle error in case of query failure
    echo json_encode([
        "status" => "error",
        "message" => "Failed to retrieve the latest order ID"
    ]);
}

mysqli_close($conn); // Close database connection
?>
